# Install AMF Library untuk Proper AMF Support

## 🔴 Masalah Saat Ini

AMF Gateway menggunakan JSON, tapi Flash client mengharapkan format AMF biner. Error:
```
NetConnection.Call.BadVersion
```

## ✅ Solusi: Install AMF Library

### Option 1: SabreAMF (Recommended)

**Install via Composer:**

```bash
cd D:\xampp\htdocs\amf_gateway
composer require sabre/amf
```

**Update index.php:**

```php
<?php
require_once 'vendor/autoload.php';
require_once 'config.php';
require_once 'db.php';

use SabreAMF\AMF;
use SabreAMF\AMF3\Deserializer;
use SabreAMF\AMF3\Serializer;

// Handle AMF request
$amf = new AMF();
$amf->setDeserializer(new Deserializer());
$amf->setSerializer(new Serializer());

// Parse AMF request
$request = $amf->deserialize(file_get_contents('php://input'));

// Handle request
$service = $request->target;
$method = $request->operation;
$params = $request->body;

// Your handler code here...

// Return AMF response
$response = $amf->serialize($result);
header('Content-Type: application/x-amf');
echo $response;
?>
```

### Option 2: AMFPHP (Legacy)

Download dari: https://github.com/neoxic/amfphp

### Option 3: Simple Workaround (Temporary)

Untuk testing, kita bisa bypass AMF dan pakai JSON dengan modifikasi client code.

## 📝 Quick Fix (Temporary)

Untuk sementara, kita bisa:
1. Fix crossdomain.xml (sudah done)
2. Return proper error message
3. Install AMF library nanti

---

**Note:** Untuk production, harus pakai AMF library yang proper.

