# AMF Gateway - Ninja Saga

Simple AMF Gateway untuk local development menggunakan PHP.

## 📋 Overview

AMF Gateway ini adalah implementasi sederhana untuk handle AMF requests dari game client. Untuk production, disarankan menggunakan library AMF yang proper seperti Zend_Amf atau SabreAMF.

## 🚀 Setup

### 1. Copy Files ke XAMPP

Copy folder `amf_gateway` ke:
```
C:\xampp\htdocs\amf_gateway\
```

### 2. Update Configuration

Edit `config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'ninjasaga');
define('DB_USER', 'root');
define('DB_PASS', ''); // Kosong untuk default XAMPP
```

### 3. Test Connection

Akses: `http://localhost/amf_gateway/`

Harus tidak ada error.

## 📁 File Structure

```
amf_gateway/
├── index.php              # Main AMF handler
├── config.php             # Configuration
├── db.php                 # Database helper
├── services/              # Service classes
│   ├── SystemService.php  # System operations
│   ├── CharacterDAO.php   # Character operations
│   └── SystemData.php     # System data
└── README.md              # This file
```

## 🔧 Services

### SystemService

**Methods:**
- `login(username, password, build_no)` - Login dengan username/password
- `snsLogin(uid, type, build_no, ...)` - Login via SNS (Facebook, etc.)
- `requireLogin(time, hash_time, uid)` - Require login untuk SNS

### CharacterDAO

**Methods:**
- `getCharactersList(session_key)` - Get list karakter
- `getCharacterById(session_key, character_id)` - Get karakter by ID
- `createCharacter(session_key, name, gender, ...)` - Create karakter baru
- `getExtraData(session_key, hash, access_token)` - Get extra data karakter

### SystemData

**Methods:**
- `get(session_key, test_version)` - Get system data

## 📝 Notes

1. **AMF Format:** Saat ini menggunakan JSON untuk simplicity. Untuk production, perlu implementasi AMF yang proper.

2. **Session Management:** Session key di-generate dan expire setelah 1 jam.

3. **Security:** Untuk production, tambahkan:
   - Input validation
   - SQL injection prevention (sudah menggunakan PDO prepared statements)
   - XSS prevention
   - Rate limiting
   - Authentication middleware

4. **Error Handling:** Error di-return dalam format AMF response.

## 🔍 Testing

### Test Database Connection

Buat file `test_db.php`:
```php
<?php
require_once 'config.php';
require_once 'db.php';

try {
    $db = getDBConnection();
    echo "OK";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
```

Akses: `http://localhost/amf_gateway/test_db.php`

### Test Service

Buat file `test_service.php`:
```php
<?php
require_once 'config.php';
require_once 'db.php';
require_once 'services/SystemService.php';

$db = getDBConnection();
$service = new SystemService($db);

try {
    $result = $service->login('test', 'test123', '3.3.00810');
    echo json_encode($result, JSON_PRETTY_PRINT);
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
```

## 🚀 Production Considerations

1. **Use Proper AMF Library:**
   - Zend_Amf
   - SabreAMF
   - AMFPHP

2. **Security:**
   - HTTPS
   - Input validation
   - Rate limiting
   - Authentication middleware
   - CSRF protection

3. **Performance:**
   - Caching
   - Database optimization
   - Connection pooling

4. **Monitoring:**
   - Error logging
   - Performance monitoring
   - Analytics

## 📚 References

- AMF Specification: http://www.adobe.com/devnet/amf.html
- Zend_Amf: https://framework.zend.com/manual/1.12/en/zend.amf.html
- SabreAMF: https://github.com/evert/sabreamf

